<?php
/**
 * Fired during plugin activation and deactivation.
 *
 * @package WP_WebP_Optimizer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin Activator Class.
 */
class WP_WebP_Optimizer_Activator {

	/**
	 * Run on plugin activation.
	 *
	 * Sets default plugin options and checks server requirements.
	 *
	 * @since 1.0.0
	 */
	public static function activate() {
		// Check PHP version
		if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
			wp_die(
				esc_html__( 'Small Image requires PHP 7.4 or higher. Please upgrade PHP.', 'Mak8it.com' ),
				esc_html__( 'Plugin Activation Error', 'Mak8it.com' ),
				array( 'back_link' => true )
			);
		}

		// Check WordPress version
		global $wp_version;
		if ( version_compare( $wp_version, '5.8', '<' ) ) {
			wp_die(
				esc_html__( 'Small Image requires WordPress 5.8 or higher. Please upgrade WordPress.', 'Mak8it.com' ),
				esc_html__( 'Plugin Activation Error', 'Mak8it.com' ),
				array( 'back_link' => true )
			);
		}

		// Set default options if they don't exist
		$default_options = array(
			'auto_convert'          => '1',
			'quality'               => '60',
			'replace_original'      => 'keep_both',
			'show_webp_in_library'  => '1',
		);

		if ( ! get_option( 'wp_webp_optimizer_settings' ) ) {
			add_option( 'wp_webp_optimizer_settings', $default_options );
		}

		// Set activation time
		add_option( 'wp_webp_optimizer_activated', current_time( 'timestamp' ) );
	}

	/**
	 * Run on plugin deactivation.
	 *
	 * Clean up temporary data if needed.
	 *
	 * @since 1.0.0
	 */
	public static function deactivate() {
		// Clean up any temporary data or scheduled events here
		// Note: We don't delete settings on deactivation, only on uninstall
		delete_option( 'wp_webp_optimizer_activated' );
	}
}

